/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.Struct;

public class FFIClosure
extends Struct<FFIClosure>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CIF;
    public static final int FUN;
    public static final int USER_DATA;

    private static native int offsets(long var0);

    protected FFIClosure(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    @Override
    protected FFIClosure create(long address, @Nullable ByteBuffer container) {
        return new FFIClosure(address, container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long user_data() {
        return FFIClosure.nuser_data(this.address());
    }

    public static FFIClosure create(long address) {
        return new FFIClosure(address, null);
    }

    @Nullable
    public static FFIClosure createSafe(long address) {
        return address == 0L ? null : new FFIClosure(address, null);
    }

    public static long nuser_data(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)USER_DATA);
    }

    static {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer offsets = stack.mallocInt(4);
            SIZEOF = FFIClosure.offsets(MemoryUtil.memAddress(offsets));
            CIF = offsets.get(0);
            FUN = offsets.get(1);
            USER_DATA = offsets.get(2);
            ALIGNOF = offsets.get(3);
        }
    }
}

